package app.firezone.synk.network.Activities;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import app.firezone.synk.network.Network.IpAddressHelper;
import app.firezone.synk.network.Network.IpAddressProvider;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityTransactionDetailBinding;

public class TransactionDetailActivity extends AppCompatActivity {

    ActivityTransactionDetailBinding binding;

    String amount, type, method, status, date, time, transactionId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding =  ActivityTransactionDetailBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        amount = getIntent().getStringExtra("amount");
        type = getIntent().getStringExtra("type");
        method = getIntent().getStringExtra("method");
        status = getIntent().getStringExtra("status");
        date = getIntent().getStringExtra("date");
        time = getIntent().getStringExtra("time");
        transactionId = getIntent().getStringExtra("transactionId");


        binding.amountTxt.setText("₹" +amount);
        binding.type.setText(type);
        binding.method.setText(method);
        binding.transactionId.setText(transactionId);
        binding.dateTime.setText(date+", " +time);


        IpAddressProvider ipProvider = new IpAddressHelper(this);
        String ipAddress = ipProvider.getIpAddress();
        binding.ipAddress.setText(ipAddress);

        String deviceModel = Build.MANUFACTURER + " " + Build.MODEL;
        binding.deviceName.setText(deviceModel);

        String appname = getString(R.string.app_name);
        binding.discription.setText("Thank you being Transaction On " + appname);


        binding.contactSupport.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(TransactionDetailActivity.this, HelpActivity.class));
            }
        });



        if (type.equalsIgnoreCase("Withdraw")) {
            try {
                String dateTimeString = date + " " + time;  // e.g. "17-06-25 17:48:45"
                Log.d("DEBUG_TIME", "DateTimeString: " + dateTimeString);

                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yy HH:mm:ss", Locale.getDefault());
                Date transactionDate = sdf.parse(dateTimeString);

                if (transactionDate == null) {
                    binding.payStatus.setText("Pending");
                    return;
                }

                long transactionMillis = transactionDate.getTime();
                long currentMillis = System.currentTimeMillis();
                long diff = currentMillis - transactionMillis;

                long thirtyMinutesMillis = 30 * 60 * 1000;

                if (diff >= thirtyMinutesMillis) {
                    binding.payStatus.setText("Success");
                    binding.payStatusCard.setBackgroundResource(R.drawable.sucessbtn);
                } else {
                    long timeLeft = thirtyMinutesMillis - diff;

                    new CountDownTimer(timeLeft, 1000) {
                        @Override
                        public void onTick(long millisUntilFinished) {
                            long hours = TimeUnit.MILLISECONDS.toHours(millisUntilFinished);
                            long minutes = TimeUnit.MILLISECONDS.toMinutes(millisUntilFinished) % 60;
                            long seconds = TimeUnit.MILLISECONDS.toSeconds(millisUntilFinished) % 60;

                            binding.payStatus.setText(String.format("%02d:%02d:%02d", hours, minutes, seconds));
                        }

                        @Override
                        public void onFinish() {
                            binding.payStatus.setText("Success");
                            binding.payStatusCard.setBackgroundResource(R.drawable.sucessbtn);
                        }
                    }.start();
                }

            } catch (ParseException e) {
                Log.e("DEBUG_TIME", "ParseException: " + e.getMessage());
                binding.payStatus.setText("Pending");
            }
        } else {
            binding.payStatus.setText("Success");
            binding.payStatusCard.setBackgroundResource(R.drawable.sucessbtn);
        }


    }
}